<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices Asterisk</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "Asterisk"; 
}
#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/asterisk-logo-twitter-share.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}
/*--------------------------------------------------------------
#asterisk
--------------------------------------------------------------*/
.asterisk {
	padding: 120px 0px;
}

.asterisk .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.asterisk .content ul {
  list-style: none;
  padding: 0;
}

.asterisk .content ul li {
  padding-bottom: 10px;
}

.asterisk .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.asterisk .content p:last-child {
  margin-bottom: 0;
}

.asterisk .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.asterisk .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.asterisk .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#asterisk .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #asterisk .animated {
    -webkit-animation: none;
    animation: none;
  }
  #asterisk .asterisk-img {
    text-align: center;
  }
  #asterisk .asterisk-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #asterisk .asterisk-img img {
	 width: 60%;
  }
  #asterisk .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #asterisk .asterisk-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}








/*--------------------------------------------------------------
# Pricing
--------------------------------------------------------------*/
#asterisk .pricing .box {
	 padding: 20px;
	 background: #fff;
	 text-align: center;
	 border-radius: 5px;
	 position: relative;
	 overflow: hidden;
	 box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#asterisk .pricing h3 {
	 font-weight: 400;
	 margin: -20px -20px 20px -20px;
	 padding: 20px 15px;
	 font-size: 16px;
	 font-weight: 600;
	 color: rgba(27,189,54);
	 background: #f8f8f8;
	 text-align: left;
}

#asterisk .pricing h4 {
  font-size: 36px;
  color: rgba(27,189,54);
  font-weight: 600;
  font-family: "Roboto", sans-serif;
  margin-bottom: 20px;
}

#asterisk .pricing h4 sup {
  font-size: 20px;
  top: -15px;
  left: -3px;
}

#asterisk .pricing h4 span {
  color: #bababa;
  font-size: 16px;
  font-weight: 300;
}

#asterisk .pricing ul {
  padding: 0;
  list-style: none;
  color: #444444;
  text-align: center;
  line-height: 20px;
  font-size: 14px;
}

#asterisk .pricing ul li {
  padding-bottom: 16px;
}

#asterisk .pricing ul i {
  color: #5846f9;
  font-size: 18px;
  padding-right: 4px;
}

#asterisk .pricing ul .na {
  color: #ccc;
  text-decoration: line-through;
}

#asterisk .pricing .btn-wrap {
  margin: 20px -20px -20px -20px;
  padding: 20px 15px;
  background: #f8f8f8;
  text-align: center;
}

#asterisk .pricing .btn-buy {
  background: linear-gradient(42deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  display: inline-block;
  padding: 10px 35px;
  border-radius: 4px;
  color: #fff;
  transition: none;
  font-size: 15px;
  font-weight: 400;
  font-family: "Roboto", sans-serif;
  font-weight: 600;
  transition: 0.3s;
}

#asterisk .pricing .btn-buy:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

#asterisk .pricing .featured h3 {
  color: #fff;
  background: rgba(27,189,54);
}

#asterisk .pricing .advanced {
  width: 200px;
  position: absolute;
  top: 18px;
  right: -68px;
  transform: rotate(45deg);
  z-index: 1;
  font-size: 14px;
  padding: 1px 0 3px 0;
  background: rgba(27,189,54);
  color: #fff;
}


/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#asterisk .faq-list {
	padding: 0px;
}
#asterisk .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#asterisk .faq-list li + li {
	 margin-top: 1px;
}
#asterisk .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#asterisk .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#asterisk .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#asterisk .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#asterisk .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#asterisk .faq-list .icon-show {
	 display: none;
}
#asterisk .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#asterisk .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#asterisk .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#asterisk .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#asterisk .faq-list {
		 padding: 0;
	}
}

/*--------------------------------------------------------------
# Counts
--------------------------------------------------------------*/
#asterisk .counts {
 /* padding: 80px 0 60px 0;*/
}

#asterisk .counts .counters i {
	color: rgba(27,189,54);
	margin-bottom: 10px;
}

#asterisk .counts .counters span {
  font-size: 48px;
  display: block;
  color: #2c4964;
  font-weight: 600;
  font-family: "Poppins", sans-serif;
}

#asterisk .counts .counters p {
  padding: 0;
  margin: 0 0 20px 0;
  font-size: 20px;
  color: #2c4964;
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= asterisk Section ======= -->
<section id="asterisk" class="asterisk">
    <div class="container">
		
		
		<div class="section-title">
          <h2>Asterisk</h2>
          <p>Asterisk is an open source framework for building communications applications. Asterisk turns an ordinary computer into a communications server.</p>
        </div>
		
		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span style="color:rgba(27,189,54)">-------</span> MULTI-PROTOCOL, REAL-TIME COMMUNICATION APPLICATION</small></small></small><br/><br/>
				Getting Started<br/>
				<span style="color:rgba(27,189,54)">with Asterisk</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>It is used by small businesses, large businesses, call centers, carriers and government agencies, worldwide.</big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/asterisk-logo-twitter-share.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Asterisk Overview</h3>
				<p class="font-italic">
					Today, there are more than one million Asterisk-based communications systems in use, in more than <b>170 countries.</b> Asterisk is used by almost the entire Fortune <b>1000 list of customers.</b> Most often deployed by system integrators and developers, Asterisk can become the basis for a complete business phone system, or used to enhance or extend an existing system, or to bridge a gap between systems.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> TDMoE (Time Division Multiplex over Ethernet)</li>
					<li><i class="ri-check-double-line"></i> Allows direct connection of Asterisk PBX</li>
					<li><i class="ri-check-double-line"></i> Zero latency</li>
					<li><i class="ri-check-double-line"></i> Uses commodity Ethernet hardware</li>
					<li><i class="ri-check-double-line"></i> Voice-over IP</li>
					<li><i class="ri-check-double-line"></i> Allows for integration of physically separate installations</li>
					<li><i class="ri-check-double-line"></i> Uses commonly deployed data connections</li>
					<li><i class="ri-check-double-line"></i> Allows a unified dialplan across multiple offices</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/key-features.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Asterisk Key features</h3>
				<p class="font-italic">
					Asterisk-based telephony solutions offer a rich and flexible feature set. Asterisk offers both classical PBX functionality and advanced features and interoperates with traditional standards-based telephony systems and Voice over IP systems. Asterisk offers the advanced features that are often associated with large, high end (and high cost) proprietary PBXs.  The list below includes a sample of the features available in Asterisk.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> ADSI On-Screen Menu System</li>
					<li><i class="ri-check-double-line"></i> Alarm Receiver, Append Message, Authentication, Automated Attendant</li>
					<li><i class="ri-check-double-line"></i> Blacklists and Blind Transfer</li>
					<li><i class="ri-check-double-line"></i> Call Detail Records, Forward on Busy, Forward on No Answer, Forward Variable, Monitoring, Parking</li>
					<li><i class="ri-check-double-line"></i> Call Queuing, Recording, Retrieval, Routing (DID & ANI), Snooping, Transfer, Waiting</li>
					<li><i class="ri-check-double-line"></i> Caller ID, Caller ID Blocking, Caller ID on Call Waiting</li>
					<li><i class="ri-check-double-line"></i> Calling Cards</li>
					<li><i class="ri-check-double-line"></i> Database Store / Retrieve and Database Integration</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Asterisk Call Features.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Asterisk Call Features</h3>
				<p class="font-italic">
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> SMS Messaging</li>
					<li><i class="ri-check-double-line"></i> Spell / Say</li>
					<li><i class="ri-check-double-line"></i> Streaming Hold Music</li>
					<li><i class="ri-check-double-line"></i> Supervised Transfer</li>
					<li><i class="ri-check-double-line"></i> Talk Detection</li>
					<li><i class="ri-check-double-line"></i> Text-to-Speech (via Festival)</li>
					<li><i class="ri-check-double-line"></i> Three-way Calling</li>
					<li><i class="ri-check-double-line"></i> Time and Date</li>
					<li><i class="ri-check-double-line"></i> Transcoding</li>
					<li><i class="ri-check-double-line"></i> Trunking</li>
					<li><i class="ri-check-double-line"></i> VoIP Gateways</li>
					<li><i class="ri-check-double-line"></i> Visual Indicator for Message Waiting</li>
					<li><i class="ri-check-double-line"></i> Stutter Dialtone for Message Waiting</li>
					<li><i class="ri-check-double-line"></i> Voicemail to email</li>
					<li><i class="ri-check-double-line"></i> Voicemail Groups</li>
					<li><i class="ri-check-double-line"></i> Web Voicemail Interface</li>
					<li><i class="ri-check-double-line"></i> Zapateller</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Asterisk VoIP Protocols.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Asterisk VoIP Protocols</h3>
				<p class="font-italic">
					The dialplan is composed of one or more extension contexts. Each extension context is itself simply a collection of extensions. Each extension context in a dialplan has a unique name associated with it. The use of contexts can be used to implement a number of important features, such as security, routing, auto-attendant, multilevel menus, authentication, callback, privacy, macros, etc.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Google Talk</li>
					<li><i class="ri-check-double-line"></i> H.323</li>
					<li><i class="ri-check-double-line"></i> IAX™ (Inter-Asterisk eXchange)</li>
					<li><i class="ri-check-double-line"></i> Jingle/XMPP</li>
					<li><i class="ri-check-double-line"></i> MGCP (Media Gateway Control Protocol</li>
					<li><i class="ri-check-double-line"></i> SCCP (Cisco® Skinny®)</li>
					<li><i class="ri-check-double-line"></i> SIP (Session Initiation Protocol)</li>
					<li><i class="ri-check-double-line"></i> UNIStim</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Asterisk User Portal.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Asterisk User Portal</h3>
				<p class="font-italic">
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Direct Inward System Access</li>
					<li><i class="ri-check-double-line"></i> Distinctive Ring</li>
					<li><i class="ri-check-double-line"></i> Distributed Universal Number Discovery (DUNDi™)</li>
					<li><i class="ri-check-double-line"></i> Do Not Disturb</li>
					<li><i class="ri-check-double-line"></i> E911</li>
					<li><i class="ri-check-double-line"></i> ENUM</li>
					<li><i class="ri-check-double-line"></i> Fax Transmit and Receive</li>
					<li><i class="ri-check-double-line"></i> Flexible Extension Logic</li>
					<li><i class="ri-check-double-line"></i> Interactive Directory Listing</li>
					<li><i class="ri-check-double-line"></i> Interactive Voice Response (IVR)</li>
					<li><i class="ri-check-double-line"></i> Local and Remote Call Agents</li>
					<li><i class="ri-check-double-line"></i> Macros</li>
					<li><i class="ri-check-double-line"></i> Music On Hold</li>
					<li><i class="ri-check-double-line"></i> Music On Transfer</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-1 content">
				
				<div class="row" style="margin:0px;padding: 0px;">
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="0">
						<div class="c100 p95 green">
							<span><i class="fal fa-drafting-compass"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>The Swiss Army Knife Of Communications</h5>
							<p class="font-italic">
								Asterisk is in use today as the core engine of many communications applications.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="100">
						<div class="c100 p90 green">
							<span><i class="fas fa-square"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Ultimate Flexibility</h5>
							<p class="font-italic">
								You might wonder how a single software package can serve so many different functions.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="200">
						<div class="c100 p98 green">
							<span><i class="far fa-surprise"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Amazing Potential</h5>
							<p class="font-italic">
								With Asterisk , you have the potential to tie communications into any application or business function.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px;" data-aos="fade-right" data-aos-delay="300">
						<div class="c100 p80 green">
							<span><i class="fal fa-info-square"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>#1 open source communications toolkit</h5>
							<p class="font-italic">
								Asterisk is full of open-source VoIP communication application
							</p>
						</div>
					</div>
				</div>
				
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Pricing</h2>
			<p></p>
        </div>
		
		
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content pricing" id="pricing">
		
				<!-- ======= Pricing Section ======= -->
				<div class="container  p-0" data-aos="fade-up">
					<div class="row">

						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>2 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E3-1270 v3 2.40 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>49<span> / month</span></h4>
								<ul>
									<li>4 GB RAM</li>
									<li>250 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 5000 GB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box featured">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-database"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>4 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2620 v3 2.50 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>99<span> / month</span></h4>
								<ul>
									<li>8 GB RAM</li>
									<li>350 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 10 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>8 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3 2.60 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>129<span> / month</span></h4>
								<ul>
									<li>16 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 20 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>8 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3 2.60 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>149<span> / month</span></h4>
								<ul>
									<li>16 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 1 Gbps</li>
									<li>Bandwidth 50 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box featured">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-database"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>12 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2620 v3 2.50 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>179<span> / month</span></h4>
								<ul>
									<li>32 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 1Gbps</li>
									<li>Bandwidth 50 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>16 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>380<span> / month</span></h4>
								<ul>
									<li>64 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 20 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
					</div>
				</div><!-- End Pricing Section -->
				
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
			
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/f9f8b11477b2dfd4ce2f248b089a8cd1.png" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>What does Voipswitch do?</h3>
				<p class="font-italic">
					<b>General Information About Voipswith</b><br/>
					Voipswitch Class 4/5 Softswitch is a multiservice telephony server that leverages SIP and other related communication protocols.
				</p>
				
				<div class="faq-list">
				<ul>
					<li data-aos="fade-up" data-aos-delay="100">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>Can I rent or onetime install the Asterisk?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-1" class="collapse" data-parent=".faq-list">
							<p>Yes, we offer both to rent and to onetime installation to your server. You can install it for any type of open source IP telephony project like a call center, IP PBX, SIP server, voice bursting, voice marketing.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="200">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>Do you offer trainings?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-2" class="collapse" data-parent=".faq-list">
							<p>Yes, we give training and others tutorial documentation with videos. Usually we provide an online session but also when requested we provide onsite training, it can be in our offices or at customer.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="300">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>Can I host the Asterisk on your server?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-3" class="collapse" data-parent=".faq-list">
							<p>Yes, we work with the datacenter in USA and Europe an can offer you a full of package including server, backup, IP addresses etc. If you are asian, we have high redundant singapore server also we care about terminated and call genaration server location which you get better call quality to fine tune. We can suggest you which colocation is better for your termination.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>On which version of open source Asterisk is Certified Asterisk based?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-4" class="collapse" data-parent=".faq-list">
							<p>The initial release of Certified Asterisk was based on <b>Asterisk 1.8.11.</b> The numbering for Certified Asterisk releases reflects the open source version from which they are built. For example, <b>asterisk-1.8.11-cert1</b> was the first certified release, derived from Asterisk 1.8.11. Versions following the initial release have been made against both Asterisk 11 and Asterisk 13 releases.  For more information about the various versions of Asterisk, please see the <b>Asterisk Versions</b> wiki page.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="500">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-5" class="collapsed"><b>Can i branded my company logo details, is there any extra cost ?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-5" class="collapse" data-parent=".faq-list">
							<p>Yes, it can be branded, not only logo can be changed but the whole skin which is based on web backend preferences. You can do it yourself or order it at our design team.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="600">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-6" class="collapsed"><b>Do I need a extra billing system?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-6" class="collapse" data-parent=".faq-list">
							<p>The billing system is built in the Asterisk platform and is fully integrated with Softswitch providing realtime and rating functionality among many other converged billing features. It uses an external database to store the data.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="700">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-7" class="collapsed"><b>How do I download Certified Asterisk?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-7" class="collapse" data-parent=".faq-list">
							<p>
								Certified Asterisk is available as RPM packages from <b>packages.asterisk.org</b> or as source code from <b>downloads.digium.com</b> or <b>svn.asterisk.org.</b>
							</p>
						</div>
					</li>
				</ul>
				</div>
			</div>
		</div>
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>TOTALLY SERVED ASTERISK TO CLIENT</h2>
			<p></p>
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-left">
				<h3>
				<span style="color:rgba(27,189,54)">Why it's worth</span>
				to choose VPS / VOS?<br/>
				</h3>
				<p class="font-italic">Our successfully delivered services to give end-users where they get full of satisfied with us.</p><br/><br/>
			</div>
			
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content counts" id="counts">
				<!-- ======= Counts Section ======= -->
				<div class="container">
					<div class="row counters">
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="150">
							<i class="fas fa-4x fa-server"></i>
							<span data-toggle="counter-up">2800+</span>
							<p>Installation provided third party server</p>
						</div>
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="300">
							<i class="fal fa-4x fa-cloud-upload"></i>
							<span data-toggle="counter-up">12300+</span>
							<p>Hosted solution provided</p>
						</div>
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="450">
							<i class="fal fa-4x fa-flag-alt"></i>
							<span data-toggle="counter-up">78+</span>
							<p>Countries we served</p>
						</div>
					</div>
				</div>
			</div>
			
		</div>
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End asterisk Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>