<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices Digital Marketing</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "Digital Marketing"; 
}
#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/Digital-Marketing-png-head.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}


/*--------------------------------------------------------------
#digital_marketing
--------------------------------------------------------------*/
.digital_marketing {
	padding: 120px 0px;
}

.digital_marketing .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.digital_marketing .content ul {
  list-style: none;
  padding: 0;
}

.digital_marketing .content ul li {
  padding-bottom: 10px;
}

.digital_marketing .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.digital_marketing .content p:last-child {
  margin-bottom: 0;
}

.digital_marketing .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.digital_marketing .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.digital_marketing .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#digital_marketing .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #digital_marketing .animated {
    -webkit-animation: none;
    animation: none;
  }
  #digital_marketing .digital_marketing-img {
    text-align: center;
  }
  #digital_marketing .digital_marketing-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #digital_marketing .digital_marketing-img img {
	 width: 60%;
  }
  #digital_marketing .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #digital_marketing .digital_marketing-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#digital_marketing .faq-list {
	padding: 0px;
}
#digital_marketing .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#digital_marketing .faq-list li + li {
	 margin-top: 1px;
}
#digital_marketing .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#digital_marketing .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#digital_marketing .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#digital_marketing .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#digital_marketing .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#digital_marketing .faq-list .icon-show {
	 display: none;
}
#digital_marketing .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#digital_marketing .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#digital_marketing .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#digital_marketing .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#digital_marketing .faq-list {
		 padding: 0;
	}
}

</style>
</head>
<body onload="mypre()">	
<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= digital marketing Section ======= -->
<section id="digital_marketing" class="digital_marketing">
    <div class="container">
		
		
		<div class="section-title">
          <h2>Digital Marketing</h2>
          <p>Basically, digital marketing refers to any online marketing efforts or assets. Email marketing, pay-per-click advertising, social media marketing and even blogging are all great examples of digital marketing.</p>
        </div>
		
		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span style="color:rgba(27,189,54)">-------</span> DIGITAL MARKETING SOLUTIONS</small></small></small><br/><br/>
				Getting Started<br/>
				<span style="color:rgba(27,189,54)">with Digital Marketing</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>Basically, digital marketing refers to any online marketing efforts or assets. Email marketing, pay-per-click advertising, social media marketing and even blogging are all great examples of digital marketing. </big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/digital_marketing-main.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What is Digital Marketing?</h3>
				<p class="font-italic">
					Any marketing that uses electronic devices to convey promotional messaging and measure its impact. In practice, digital marketing typically refers to marketing campaigns that appear on a computer, phone, tablet, or other device. It can take many forms, including online video, display ads, and social media posts. Digital marketing is often compared to “traditional marketing” such as magazine ads, billboards, and direct mail. Oddly, television is usually lumped in with traditional marketing.
					<br/><br/>
					<b>Digital Marketing Assets</b><br/>
					Almost anything can be a digital marketing asset. It simply needs to be a marketing tool you use online. That being said, many people don’t realize how many digital marketing assets they have at their disposal. Here are just a few examples:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i>  Your website</li>
					<li><i class="ri-check-double-line"></i>  Branded assets (logos, icons, acronyms, etc)</li>
					<li><i class="ri-check-double-line"></i>  Video content (video ads, product demos, etc)</li>
					<li><i class="ri-check-double-line"></i>  Images (infographics, product shots, company photos, etc)</li>
					<li><i class="ri-check-double-line"></i>  Written content (blog posts, eBooks, product descriptions, testimonials, etc)</li>
					<li><i class="ri-check-double-line"></i>  Online products or tools (SaaS, calculators, interactive content, etc)</li>
					<li><i class="ri-check-double-line"></i>  Reviews</li>
					<li><i class="ri-check-double-line"></i>  Social media pages</li>
				</ul>
				<a href="digital_marketing.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Types of digital marketing</h2>
			<p>The list of digital marketing strategies is also constantly evolving, but here are some of the strategies most businesses are using. </p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/important-seo-factors-featured-image.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Search engine optimization</h3>
				<p class="font-italic">
					Search engine optimization, or SEO, is technically a marketing tool rather than a form of marketing in itself. The Balance defines it as “the art and science of making web pages attractive to search engines.”
					<br/><br/>
					The "art and science" part of SEO is what’s most important. SEO is a science because it requires you to research and weigh different contributing factors to achieve the highest possible ranking. Today, the most important elements to consider when optimizing a web page include:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Quality of content</li>
					<li><i class="ri-check-double-line"></i> Level of user engagement</li>
					<li><i class="ri-check-double-line"></i> Mobile-friendliness</li>
					<li><i class="ri-check-double-line"></i> Number and quality of inbound links</li>
				</ul>
				<p class="font-italic">
					The strategic use of these factors makes SEO a science, but the unpredictability involved makes it an art.<br/><br/>
					In SEO, there's no quantifiable rubric or consistent rule for ranking highly. Google changes its algorithm almost constantly, so it's impossible to make exact predictions. What you can do is closely monitor your page's performance and make adjustments accordingly.<br/><br/>
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/content-marketing-4111003_1920.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Content marketing</h3>
				<p class="font-italic">
					SEO is a major factor in content marketing, a strategy based on the distribution of relevant and valuable content to a target audience.<br/><br/>
					As in any marketing strategy, the goal of content marketing is to attract leads that ultimately convert into customers. But it does so differently than traditional advertising. Instead of enticing prospects with potential value from a product or service, it offers value for free in the form of written material.<br/><br/>
					<b>Content marketing matters, and there are plenty of stats to prove it:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> 84% of consumers expect companies to produce entertaining and helpful content experiences</li>
					<li><i class="ri-check-double-line"></i> 62% of companies that have at least 5,000 employees produce content daily</li>
					<li><i class="ri-check-double-line"></i> 92% of marketers believe that their company values content as an important asset</li>
				</ul>
				<p class="font-italic">
					As effective as content marketing is, it can be tricky. Content marketing writers need to be able to rank highly in search engine results while also engaging people who will read the material, share it, and interact further with the brand. When the content is relevant, it can establish strong relationships throughout the pipeline.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Social-Media-Strategies@2x-1024x517.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Social media marketing</h3>
				<p class="font-italic">
					<b>bSocial media marketing</b> means driving traffic and brand awareness by engaging people in discussion online. The most popular platforms for social media marketing are Facebook, Twitter, and Instagram, with LinkedIn and YouTube not far behind.<br/><br/>
					Because social media marketing involves active audience participation, it has become a popular way of getting attention. It's the most popular content medium for B2C marketers at 96%, and it's gaining ground in the B2B sphere as well. According to the Content Marketing Institute, 61% of B2B content marketers increased their use of social media this year.<br/><br/>
					Social media marketing offers built-in engagement metrics, which are extremely useful in helping you to understand how well you're reaching your audience. You get to decide which types of interactions mean the most to you, whether that means the number of shares, comments, or total clicks to your website.<br/><br/>
					Direct purchase may not even be a goal of your social media marketing strategy. Many brands use social media marketing to start dialogues with audiences rather than encourage them to spend money right away. This is especially common in brands that target older audiences or offer products and services not appropriate for impulse buys. It all depends on your company's goals.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Pay-per-click marketing.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Pay-per-click marketing</h3>
				<p class="font-italic">
					Pay-per-click, or PPC, is posting an ad on a platform and paying every time someone clicks on it.<br/><br/>
					How and when people see your ad is a bit more complicated. When a spot is available on a search engine results page, also known as a SERP, the engine fills the spot with what is essentially an instant auction. An algorithm prioritizes each available ad based on a number of factors, including:<br/><br/>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Ad quality</li>
					<li><i class="ri-check-double-line"></i> Keyword relevance</li>
					<li><i class="ri-check-double-line"></i> Landing page quality</li>
					<li><i class="ri-check-double-line"></i> Bid amount</li>
					
				</ul>
				<p class="font-italic">
					Each PPC campaign has 1 or more target actions that viewers are meant to complete after clicking an ad. These actions are known as conversions, and they can be transactional or non-transactional. Making a purchase is a conversion, but so is a newsletter signup or a call made to your home office.
					<br/><br/>
					Whatever you choose as your target conversions, you can track them via your chosen platform to see how your campaign is doing.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Affiliate marketing.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Affiliate marketing</h3>
				<p class="font-italic">
					<b>Affiliate marketing</b> lets someone make money by promoting another person's business. You could be either the promoter or the business who works with the promoter, but the process is the same in either case.<br/><br/>
					It works using a revenue sharing model. If you're the affiliate, you get a commission every time someone purchases the item that you promote. If you're the merchant, you pay the affiliate for every sale they help you make.<br/><br/>
					Some affiliate marketers choose to review the products of just 1 company, perhaps on a blog or other third-party site. Others have relationships with multiple merchants.<br/><br/>
					Whether you want to be an affiliate or find one, the first step is to <b>bmake a connection with the other party.</b> You can use a platform designed to connect affiliates with retailers, or you can start or join a single-retailer program.<br/><br/>
					If you're a retailer and you choose to work directly with affiliates, there are many things you can do to make your program appealing to potential promoters. You'll need to provide those affiliates with the tools that they need to succeed. That includes incentives for great results as well as marketing support and pre-made materials.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Native advertising.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Native advertising</h3>
				<p class="font-italic">
					<b>Native advertising</b> is marketing in disguise. Its goal is to blend in with its surrounding content so that it’s less blatantly obvious as advertising.<br/><br/>
					Native advertising was created in reaction to the cynicism of today's consumers toward ads. Knowing that the creator of an ad pays to run it, many consumers will conclude that the ad is biased and consequently ignore it.<br/><br/>
					A native ad gets around this bias by offering information or entertainment before it gets to anything promotional, downplaying the "ad" aspect.<br/><br/>
					It’s important to always <b>label your native ads clearly.</b> Use words like “promoted” or “sponsored.” If those indicators are concealed, readers might end up spending significant time engaging with the content before they realize that it's advertising.<br/><br/>
					When your consumers know exactly what they're getting, they'll feel better about your content and your brand. Native ads are meant to be less obtrusive than traditional ads, but they’re not meant to be deceptive.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Marketing automation.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Marketing automation</h3>
				<p class="font-italic">
					Marketing automation uses software to power digital marketing campaigns, improving the efficiency and relevance of advertising.<br/><br/>
					<b>According to statistics:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> 90% of US consumers find personalization either “very” or “somewhat” appealing</li>
					<li><i class="ri-check-double-line"></i> 81% of consumers would like the brands they engage with to understand them better</li>
					<li><i class="ri-check-double-line"></i> 77% of companies believe in the value of real-time personalization, yet 60% struggle with it</li>
				</ul>
				<p class="font-italic">
					<b>Marketing automation lets companies keep up with the expectation of personalization. It allows brands to:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Collect and analyze consumer information</li>
					<li><i class="ri-check-double-line"></i> Design targeted marketing campaigns</li>
					<li><i class="ri-check-double-line"></i> Send and post marketing messages at the right times to the right audiences</li>					
				</ul>
				<p class="font-italic">
					Many marketing automation tools use prospect engagement (or lack thereof) with a particular message to determine when and how to reach out next. This level of real-time customization means that you can effectively create an individualized marketing strategy for each customer without any additional time investment.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Email marketing.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Email marketing</h3>
				<p class="font-italic">
					The concept of email marketing is simple—you send a promotional message and hope that your prospect clicks on it. However, the execution is much more complex. First of all, you have to make sure that your emails are wanted. This means having an opt-in list <b>that does the following:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Individualizes the content, both in the body and in the subject line</li>
					<li><i class="ri-check-double-line"></i> States clearly what kind of emails the subscriber will get</li>
					<li><i class="ri-check-double-line"></i> Offers a clear unsubscribe option</li>
					<li><i class="ri-check-double-line"></i> Integrates both transactional and promotional emails</li>
				</ul>
				<p class="font-italic">
					You want your prospects to see your campaign as a valued service, not just as a promotional tool.<br/><br/>
					Email marketing is a proven, effective technique all on its own: 89% of surveyed professionals named it as their most effective lead generator.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Paid Social Media Advertising.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Paid Social Media Advertising</h3>
				<p class="font-italic">
					Most social media platforms like Facebook, Instagram, Twitter, LinkedIn, Pinterest and Snapchat will allow you to run ads on their site. Paid social media advertising is great for building awareness with audiences that might not be aware that your business, product or service exists.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Conversion Rate Optimization (CRO).png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Conversion Rate Optimization (CRO)</h3>
				<p class="font-italic">
					Conversion rate optimization (CRO) is the art and science of improving your online user experience. Most of the time, businesses use CRO to get more conversions (leads, chats, calls, sales, etc) out of their existing website traffic.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="digital_marketing.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>

		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-1 content">
				
				<div class="row" style="margin:0px;padding: 0px;">
					<div class="col-lg-3 col-12 pb-4 pt-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="0">
						<div class="c100 p95 green">
							<span><i class="fal fa-integral"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>A broad geographic reach</h5>
							<p class="font-italic">
								When you post an ad online, people can see it no matter where they are (provided you haven’t limited your ad geographically). This makes it easy to grow your business's market reach.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-12 pb-4 pt-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="100">
						<div class="c100 p90 green">
							<span><i class="fas fa-square"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Cost efficiency</h5>
							<p class="font-italic">
								Digital marketing not only reaches a broader audience than traditional marketing but also carries a lower cost. 
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-12 pb-4 pt-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="200">
						<div class="c100 p98 green">
							<span><i class="fal fa-mind-share"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Quantifiable results</h5>
							<p class="font-italic">
								To know whether your marketing strategy works, you have to find out how many customers it attracts and how much revenue it ultimately drives.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-12 pb-4 pt-4" style="margin:0px;padding: 0px;" data-aos="fade-right" data-aos-delay="300">
						<div class="c100 p80 green">
							<span><i class="fal fa-location-arrow"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Easier personalization</h5>
							<p class="font-italic">
								Digital marketing allows you to gather customer data in a way that offline marketing can't. Data collected digitally tends to be much more precise and specific.
							</p>
						</div>
					</div>
				</div>
				
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Digital_Marketing_works-1.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Does Digital Marketing Work?</h3>
				<p class="font-italic">
					Digital marketing is a great option for any business. At Disruptive, we’ve used digital marketing to help all kinds of businesses grow—from mom-and-pop shops to internationally recognized universities and beyond. That’s the beauty of advertising online. If you know who you want to target, you can use digital marketing to target anyone, anywhere.
					<br/><br/>
					However, that being said, certain types of businesses will benefit more from certain types of digital advertising. As a quick overview, let’s take a look at which strategies tend to work best for business-to-consumer (B2C) companies and business-to-business (B2B) companies:
				</p>
				<a href="digital_marketing.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/B2C Companies.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>B2C Companies</h3>
				<p class="font-italic">
					Generally speaking, B2C companies have much lower price points than their B2B counterparts. After all, it can be a little hard to sell a $150,000 drill bit (believe me, they exist) to a harried mom. But a $10 pair of kids pants? That’s a fairly straightforward sell.<br/><br/>
					The good news is, because B2C companies aren’t trying to sell incredibly expensive products or services, they don’t need big sales teams or complicated marketing funnels. All they have to do is get their products or services in front of the right audience with the right messaging and the rest should take care of itself.<br/><br/>
					As a result, the primary goal of most B2C companies is to get people into and through their marketing funnel. For example, if you can get that harried mom onto your kids clothing website and offer her an exciting deal, there’s a good chance that she’ll buy today. You don’t need to build a ton of brand awareness or trust before you can close a sale.<br/><br/>
					With that in mind, B2C companies often see great results from higher-funnel marketing channels like social media marketing or paid social advertising. These channels do a great job of getting your business in front of potential customers who might not otherwise know that you exist.<br/><br/>
					Now, supplementing with other digital marketing strategies like paid search or SEO is always a good idea, but if you have to pick one channel to start with, paid social advertising or social media marketing are great options for B2C.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/B2B Companies.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>B2B Companies</h3>
				<p class="font-italic">
					In contrast, paid search is a great option for B2B companies. Most B2B companies have very specific niche audiences that can be hard to target using social media. However, if you sell $150,000 drill bits and someone searches for “diamond-tipped oil drilling bit manufacturer”, you want to be the first result they see. Yes, you might pay more for your click than you would with paid social advertising, but with a $150,000 price tag, it’s money well spent.<br/><br/>
					In addition, most B2B companies have a much longer and more involved sales cycle than B2C companies. If you’re selling a $150,000 drill bit, most people probably don’t come to your site, give you a call and say “I want one.” As a result, longer-term strategies like content marketing or email marketing are often necessary to close a deal.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="digital_marketing.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
			
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/How Do I Get Started.jpg" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>How Do I Get Started?</h3>
				<p class="font-italic">
					<b>General Information About Digital Marketing</b><br/>
					The good news is, getting started with digital marketing is fairly easy. Most online advertising platforms make it easy to sign up and create your first campaign (it is how they make money, after all). Here are a few links to beginner guides for several different digital marketing strategies:
				</p>
				<ul>
					
					<li><i class="ri-check-double-line"></i> Paid search advertising</li>
					<li><i class="ri-check-double-line"></i> Search engine optimization (SEO)</li>
					<li><i class="ri-check-double-line"></i> Paid social media advertising</li>
					<li><i class="ri-check-double-line"></i> Social media marketing</li>
					<li><i class="ri-check-double-line"></i> Conversion rate optimization</li>
					<li><i class="ri-check-double-line"></i> Content marketing</li>
					<li><i class="ri-check-double-line"></i> Email marketing</li>
				</ul>
				<p class="font-italic">
					The core of every successful digital marketing campaign, however, isn’t a guide. Regardless of which strategies you choose to use, here are 4 questions you need to answer before you get started with digital marketing:
				</p>
				<div class="faq-list">
				<ul>
					<li data-aos="fade-up" data-aos-delay="100">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>How Much Do You Need to Make?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-1" class="collapse" data-parent=".faq-list">
							<p>To figure out what you need to spend on digital marketing, you first need to clarify what your goals are. How you approach digital marketing can vary quite a bit depending on whether your ultimate goal is to drive clicks, conversions or leads, sales, revenue or a certain return-on-investment (ROI).<br/><br/>
							When you get right down to it, the ultimate goal of any marketing effort should be ROI. After all, if your digital marketing spend isn’t driving profitable revenue for your business, why are you marketing online?</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="200">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>Who Are You Marketing To?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-2" class="collapse" data-parent=".faq-list">
							<p>Once you know how much money you want to make from digital marketing, you need to identify who you are marketing to. This is critical, because different buyer personas require different marketing tactics. And, even more importantly, different buyer personas turn into different types of buyers.<br/><br/>
							So guess what? If you don’t understand your buyer personas, you can’t create an effective digital marketing strategy!<br/><br/>
							If you’ve got a sales team, talking to sales can be one of the fastest ways to get a decent buyer persona together. After all, they’re the ones who talk to your customers the most, right?</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="300">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>What are Your Customers Worth?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-3" class="collapse" data-parent=".faq-list">
							<p>Typically, people look at buyer personas as a good way to craft an effective marketing strategy. Buyer personas are great for this, but they are also an important part of putting together an effective digital marketing plan.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>How Much Do You Need to Spend to Reach Your Goals?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-4" class="collapse" data-parent=".faq-list">
							<p>At this point, things are pretty simple. Just take your CAC, average purchase order value and average number of purchases (if you have a subscription model, you can just use the average lifespan of each buyer persona here) and plug them into this calculator!</p>
						</div>
					</li>
				</ul>
				</div>
			</div>
		</div>
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End digital_marketing Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>