<?php // 12 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
#development
--------------------------------------------------------------*/
.development {
	padding: 120px 0px 10px 0px;
}

.development .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.development .content ul {
  list-style: none;
  padding: 0;
}

.development .content ul li {
  padding-bottom: 10px;
}

.development .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.development .content p:last-child {
  margin-bottom: 0;
}

.development .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.development .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.development .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#development .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #development .animated {
    -webkit-animation: none;
    animation: none;
  }
  #development .development-img {
    text-align: center;
  }
  #development .development-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #development .development-img img {
	 width: 60%;
  }
  #development .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #development .development-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= development Section ======= -->
<section id="development" class="development">
    <div class="container">
		
		<div class="section-title">
          <h2>Development Service</h2>
          <p>Web development is the work involved in developing a Web site for the Internet (World Wide Web) or an intranet (a private network).<br/>
		  It is a process to create computer software using one or more specific programming languages that provides functionality to address particular business or personal objectives.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-2 development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Web-Design-and-Development-Services-in-Amaravati.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Website Development?</h3>
				<p class="font-italic">
					Web development is the work involved in developing a Web site for the Internet (World Wide Web) or an intranet (a private network). Web development can range from developing a simple single static page of plain text to complex web applications, electronic businesses, and social network services. A more comprehensive list of tasks to which Web development commonly refers, may include Web engineering, Web design, Web content development, client liaison, client-side/server-side scripting, Web server and network security configuration, and e-commerce development.
					<br/><br/>
					Among Web professionals, "Web development" usually refers to the main non-design aspects of building Web sites: writing markup and coding. Web development may use content management systems (CMS) to make content changes easier and available with basic technical skills.
					<br/><br/>
				</p>
				<a href="website_development.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="development.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					</div>
				</div>
			</div>
			
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Software-development.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Software Development?</h3>
				<p class="font-italic">
					Software development is the process programmers use to build computer programs. The process, also known as the Software Development Life Cycle (SDLC), includes several phases that provide a method for building products that meet technical specifications and user requirements.
					<br/><br/>
					The SDLC provides an international standard that software companies can use to build and improve their computer programs. It offers a defined structure for development teams to follow in the design, creation and maintenance of high-quality software. The aim of the IT software development process is to build effective products within a defined budget and timeline.
				</p>
				<a href="software_development.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="development.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					</div>
				</div>
			</div>
			
        </div>

    </div>
</section><!-- End development Section -->
</body>
</html>