<?php // 3 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
# voip
--------------------------------------------------------------*/
.voip {
	padding: 120px 0px 10px 0px;
}

.voip .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.voip .content ul {
  list-style: none;
  padding: 0;
}

.voip .content ul li {
  padding-bottom: 10px;
}

.voip .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.voip .content p:last-child {
  margin-bottom: 0;
}

.voip .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
   background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
  position: relative;
}

.voip .content .read-more:hover {
   background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.voip .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#voip .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #voip .animated {
    -webkit-animation: none;
    animation: none;
  }
  #voip .voip-img {
    text-align: center;
  }
  #voip .voip-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #voip .voip-img img {
	 width: 60%;
  }
  #voip .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #voip .voip-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
 
 
 
 

</style>
</head>
<body>	
<!-- ======= Voip Section ======= -->
<section id="voip" class="voip">
    <div class="container">
		
		<div class="section-title">
          <h2>VoIP Phone</h2>
          <p>The Definitive Guide to a VoIP Phone System.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-1 voip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Business-Phone-Service1.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>What Is VoIP?</h3>
				<p class="font-italic">
					VOIP is an acronym for Voice Over Internet Protocol, or in more common terms phone service over the Internet.<br/>
					If you have a reasonable quality Internet connection you can get phone service delivered through your Internet connection instead of from your local phone company.
					<br/>
					
					Some common features might include:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> audio calls & video calls.</li>
					<li><i class="ri-check-double-line"></i> voicemail & instant messaging.</li>
					<li><i class="ri-check-double-line"></i> team chats & email.</li>
					<li><i class="ri-check-double-line"></i> mobile and desktop apps.and</li>
					<li><i class="ri-check-double-line"></i> mobile and local number portability (allows a subscriber to choose a new telephone carrier without needing a new number).</li>
				</ul>
				<a href="voip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<a href="voip.php#voipworks" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">How Does VoIP Works <i class="icofont-long-arrow-right"></i></a>
			
						<a href="voip.php#voipcodecs" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="300">What Are VoIP Codecs <i class="icofont-long-arrow-right"></i></a>
					</div>
					<div class="col-lg-6 col-md-12 col-12">
						<a href="voip.php#voipbusiness" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="450">What Is VoIP Business <i class="icofont-long-arrow-right"></i></a>
						
						<a href="voip.php#connect" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="600">How To Connect With VoIP To Network <i class="icofont-long-arrow-right"></i></a>
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End Voip Section -->
</body>
</html>






