<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices VoIP Phone</title>
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "Session Initiation Protocol (Sip)"; 
}

/*--------------------------------------------------------------
# sip
--------------------------------------------------------------*/
.sip {
	padding: 120px 0px;
}

.sip .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.sip .content ul {
  list-style: none;
  padding: 0;
}

.sip .content ul li {
  padding-bottom: 10px;
}

.sip .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.sip .content p:last-child {
  margin-bottom: 0;
}

.sip .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.sip .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.sip .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#sip .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #sip .animated {
    -webkit-animation: none;
    animation: none;
  }
  #sip .sip-img {
    text-align: center;
  }
  #sip .sip-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #sip .sip-img img {
	 width: 60%;
  }
  #sip .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #sip .sip-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= sip Section ======= -->
<section id="sip" class="sip">
    <div class="container">
	
		<a id="whatissip"></a>
		<div class="section-title">
          <h2>Sip</h2>
          <p>Session Initiation Protocol (SIP) is a signaling protocol used for initiating, maintaining, modifying and terminating.</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 sip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/esi-ecloud-pbx.8ba5bdb.3520ebf646095fc71bd44fd1febb8411.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What Is Sip (Session Initiation Protocol)?</h3>
				<p class="font-italic">
					Session Initiation Protocol (SIP) is used to signal and control interactive communication sessions. The uses for such sessions include voice, video, chat and instant messaging, as well as interactive games and virtual reality. The SIP protocol is increasingly being used to provide Voice over IP, Presence and Instant Messaging in Next Generation Networks, and being mandated for many new applications, including 3G telephony.
					<br/><br/>
					SIP is a protocol developed primarily by the SIPCORE working group of the IETF (see the SIPCORE Charter) and is an alternative to the ITU Recommendation H.323, but is a more lightweight and general-purpose, text-based protocol based on HTTP.
					<br/><br/>
					SIP can be used to control Internet multimedia conferences, Internet telephone calls and multimedia distribution, in both the core and the periphery of the communications network.
				</p>
				<a href="sip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<a id="sipworks"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 sip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Business-Phone-Service1.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>How Does Sip Works?</h3>
				<p class="font-italic">
					Session Initiation Protocol works with bidirectional communication. For every SIP message, one device sends a request, and the other device receives and later responds.
					<br/><br/>
					Responses are coded based on their message. Different preceding numbers in a three-digit sequence have different meanings.
					<br/><br/>
					For example, 1xx response codes mean the device received and is processing the message. Codes starting with 2xx mean completion, 3xx is used for redirections, etc.
					<br/><br/>
					The most common code is 200, meaning the action was completed successfully without further details.
					<br/><br/>
					A SIP request or reply is relatively short, with just a few lines explaining the details of the call.
					
					
				</p>
				<a href="sip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<a id="sipregistrar"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 sip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/hosted-pbx-vs-sip-trunking-diagram-1.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What is the role of a SIP registrar?</h3>
				<p class="font-italic">
					While SIP messages can contact another party directly, they usually go through a SIP proxy server—kind of like a switchboard.
					<br/><br/>
					The SIP server handles SIP requests and directs them to individual users. From there, devices establish trusted communication with each other. Where does a SIP request come from? Most likely, these requests originate from a SIP Phone or a softphone app.
					<br/><br/>
					A SIP registrar is similar to an address book. It associates the various users with the access points on the IP network where one can reach them.
					<br/><br/>
					Notably, a user’s address is not an IP address, but a separate SIP address that resembles an email. This identifier is what allows multiple devices such as a smartphone or a desk phone to ring at the same time.
					<br/><br/>
					A related but different type of server is a redirect server. It works similar to the post office’s change of address function, where it forwards mail to a new location.
					<br/><br/>
					Like a registrar, a redirect server has a list of locations. But instead of making connections, the server sends a 3xx redirect message that indicates the site has moved.
					<br/><br/>
					Related: What Is IP PBX? A-Z Guide to VoIP Servers & IP PBXs
				</p>
				<a href="sip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<a id="tcporudp"></a>
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 sip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/TCP-vs-UDP-Blog-Image.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Does SIP use TCP or UDP?</h3>
				<p class="font-italic">
					Transmission Control Protocol (TCP) and User Datagram Protocol (UDP) are different ways to send data packets. Both methods are called transport protocols.
				</p>
				
				<ul>
					<li><i class="ri-check-double-line"></i> TCP is designed for accuracy</li>
				</ul>
				<p class="font-italic">
					TCP prevents confusion and works with inherent redundancy. To send the next packet, the sender must receive a confirmation response. If the receiving party doesn’t deliver a response within a few seconds (or the sender gets an error message), the sending party resends the packet. This exchange is often referred to as a three-way handshake.
					<br/><br/>
					Packets are sent one at a time, only after they’re received correctly. Applications where accuracy is a top priority, like email and websites, typically use this protocol.
				</p>
				
				<ul>
					<li><i class="ri-check-double-line"></i> UDP is built for speed</li>
				</ul>
				<p class="font-italic">
					UDP maximizes speed. This protocol sends packets without confirmation, and even sometimes dispatched out of order. For services like live audio or video, constant communication is more critical than perfect contact.
					<br/><br/>
					Skipping or misplacing a few milliseconds of audio is preferable to a lag of a few seconds waiting for a packet to be confirmed or resent.
					<br/><br/>
					For the initial SIP request, however, either can be used. Since it’s a small packet, the possible lag times of TCP aren’t noticeable. However, some services choose to use UDP. It depends on the carrier and technical details of your setup.
				</p>
				<a href="sip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		<?php include('public/ready_to_get_started.php');?> 
		

    </div>
</section><!-- End sip Section -->


</main><!-- End #main -->





<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>