<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices VoIP Phone</title>
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "VoIP Phone"; 
}

/*--------------------------------------------------------------
# voip
--------------------------------------------------------------*/
.voip {
	padding: 120px 0px;
}

.voip .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.voip .content ul {
  list-style: none;
  padding: 0;
}

.voip .content ul li {
  padding-bottom: 10px;
}

.voip .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.voip .content p:last-child {
  margin-bottom: 0;
}

.voip .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.voip .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.voip .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#voip .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #voip .animated {
    -webkit-animation: none;
    animation: none;
  }
  #voip .voip-img {
    text-align: center;
  }
  #voip .voip-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #voip .voip-img img {
	 width: 60%;
  }
  #voip .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #voip .voip-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

/*--------------------------------------------------------------
# table
--------------------------------------------------------------*/

#voip #codecs {
	 font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
	 border-collapse: collapse;
	 width: 100%;
	 font-size: 16px;
}
#voip #codecs td, #voip #codecs th {
	 border: 1px solid #ddd;
	 padding: 8px;
}
#voip #codecs tr:nth-child(even){background-color: #f2f2f2;}
#voip #codecs tr:hover {background-color: #ddd;}
#voip #codecs th {
	 padding-top: 12px;
	 padding-bottom: 12px;
	 text-align: left;
	 background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
	 position: relative;
	 color: white;
	 font-size: 18px;
	 text-align: center;
}

/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#voip .faq-list {
	padding: 0px;
}
#voip .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#voip .faq-list li + li {
	 margin-top: 1px;
}
#voip .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#voip .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#voip .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#voip .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#voip .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#voip .faq-list .icon-show {
	 display: none;
}
#voip .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#voip .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#voip .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#voip .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#voip .faq-list {
		 padding: 0;
	}
}

</style>
</head>
<body onload="mypre()">	
<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

	<!-- ======= Voip Section ======= -->
	<section id="voip" class="voip">
		<div class="container">
			
			<div class="section-title">
			<h2>VoIP Phone</h2>
			<p>The Definitive Guide to a VoIP Phone System.</p>
			</div>
			
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-2 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/Business-Phone-Service1.png" class="rounded img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
					<h3>What Is VoIP?</h3>
					<p class="font-italic">
						VOIP is an acronym for Voice Over Internet Protocol, or in more common terms phone service over the Internet.<br/>
						If you have a reasonable quality Internet connection you can get phone service delivered through your Internet connection instead of from your local phone company.
						<br/>
						
						Some common features might include:
					</p>
					<ul>
						<li><i class="ri-check-double-line"></i> audio calls & video calls.</li>
						<li><i class="ri-check-double-line"></i> voicemail & instant messaging.</li>
						<li><i class="ri-check-double-line"></i> team chats & email.</li>
						<li><i class="ri-check-double-line"></i> mobile and desktop apps.and</li>
						<li><i class="ri-check-double-line"></i> mobile and local number portability (allows a subscriber to choose a new telephone carrier without needing a new number).</li>
					</ul>
					<a href="voip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
				</div>
			</div>

			<a id="voipworks"></a>
			<div class="section-title" style="margin-top: 120px;">
			<h2>How Does VoIP Works</h2>
			<p>VoIP is telephone service over the internet. VoIP has been around for a while now and is adopted worldwide by pretty much every organisation (startups, SMEs and even enterprises), and is the first choice for any organisation looking for a new phone system.</p>
			</div>
			
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-1 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/Sipink-Main.png" class="rounded img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
					<h3>Create Your Profile</h3>
					<p class="font-italic">
						First, you need to signup and select a plan that suits your requirements.
					</p>
				</div>
			</div>
			
			<div class="section-title" style="margin-top: 120px;">
			</div>
		
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-2 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/Mask-Group-251@2x-1024x735.png" class="rounded img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
					<h3>Select A Plan</h3>
					<p class="font-italic">
						We provide a free plan to get every small business up and running with virtually no cost. or trial or large packages for 30 days free*.
					</p>
				</div>
			</div>
			
			<div class="section-title" style="margin-top: 120px;">
			</div>
		
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-1 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/istockphoto-638534638-612x612.jpg" class="rounded img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
					<h3>Use your assigned number</h3>
					<p class="font-italic">
						When you sign up, we give you a free UK landline telephone number (that’s yours forever*) – provided that you use it.
					</p>
				</div>
			</div>
			
			<div class="section-title" style="margin-top: 120px;">
			</div>
		
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
					<a href="voip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
				</div>
			</div>
			
			
			<div class="section-title" style="margin-top: 120px;">
			<a id="voipcodecs"></a>
			</div>
			
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-2 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/the-types-of-voip-codecs.jpg" class="rounded img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
					<h3>What Are VoIP Codecs?</h3>
					<p class="font-italic">
						Codecs (Coder/Decoder) serve to encode voice/video data for transmission across IP networks. The compression capability of a codec facilitates saving network bandwidth and it is therefore appropriate that you choose the correct codec for your IP network. Here is a quick reference to the codecs with the corresponding packets size and bandwidth usage.
					</p>
				</div>
				
				<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-2 content">
					
					<ul style="margin-top: 70px;">
						<li><i class="ri-check-double-line"></i> In Table 1, there are codecs belonging to Group I (waveform codecs) with notes on basic characteristics</li>
						<li><i class="ri-check-double-line"></i> <b>Table 1: </b>Common waveform codecs used in VoIP</li>
					</ul>
					
					<div style="width: 100%;overflow-x:auto;" data-aos="fade-up">
						<table id="codecs">
							<tr>
								<th>Name<br/>(Standard)</th><th>Description</th><th>Bit rate <br/>[kbps]</th><th>Sampling<br/>[kHz]</th><th>Frame size<br/>[ms]</th><th>Notes</th>
							</tr>
							<tr>
								<td>G.711 (ITU-T)</td><td>PCM</td><td>64</td><td>8</td><td>Sample-based</td><td>A-law &amp; μ-law</td>
							</tr>
							<tr>
								<td>G.711.1 (ITU-T)</td><td>PCM</td><td>80-96</td><td>8/16</td><td>Sample-based</td><td></td>
							</tr>
							<tr>
								<td>G.721 (ITU-T)</td><td>ADPCM</td><td>32</td>
								<td>8</td><td>Sample-based</td><td>Now G.726</td>
							</tr>
							<tr>
								<td>G.722 (ITU-T)</td><td>2-band ADPCM</td><td>64</td><td>16</td><td>Sample-based</td><td></td>
							</tr>
							<tr>
								<td>G.722.1 (ITU-T)</td><td>MLT</td><td>24/32</td><td>16</td><td>20</td><td></td>
							</tr>
							<tr>
								<td>G.722.2 (ITU-T)</td><td>AMR-WB</td><td>6.6 – 23.85</td><td>16</td><td>20</td><td>Main app: 3rd gen mobile</td>
							</tr>
							<tr>
								<td>G.723 (ITU-T)</td><td>ADPCM-extension</td><td>24/40</td><td>8</td><td>Sample-based</td><td>Now G.726</td>
							</tr>
							<tr>
								<td>G.726&nbsp; (ITU-T)</td><td>ADPCM</td><td>16/24/32/40</td><td>8</td><td>Sample-based</td><td>Replaces G.721 and G.723</td>
							</tr>
							<tr>
								<td>G.727&nbsp; (ITU-T)</td><td>ADPCM</td><td>Variable</td><td>8</td><td>Sample-based</td><td>Similar to G.726</td>
							</tr>
							<tr>
								<td>DVI (IMA)</td><td>DVI4 uses ADPCM</td><td>32</td><td>Variable</td><td>Sample-based</td><td></td>
							</tr>
							<tr>
								<td>L16</td><td>Linear PCM</td><td>128</td><td>Variable</td><td>Sample-based</td><td>WB (uncompressed)</td>
							</tr>
						</table>
					</div>
					
					<ul style="margin-top: 70px;">
						<li><i class="ri-check-double-line"></i> In Table 2, there are codecs belonging to Group II (model-based codecs, i.e., related directly or indirectly to Linear Prediction models) with notes on basic characteristics.</li>
						<li><i class="ri-check-double-line"></i> <b>Table 2: </b>Common model-based (LP-related) codecs used in VoIP</li>
					</ul>
					
					<div style="width: 100%;overflow-x:auto;" data-aos="fade-up">
						<table id="codecs">
							<tr>
								<th>Name<br/>(Standard)</th><th>Description</th><th>Bit rate<br/>[kbps]</th><th>Sampling<br/>[kHz]</th><th>Frame size<br/>[ms]</th><th>Notes</th>
							</tr>
							<tr>
								<td>G.723.1 (ITU-T)</td><td>MP-MLQ and ACELP</td><td>5.6/6.3</td><td>8</td><td>30</td><td>A part of H.323 video conf</td>
							</tr>
							<tr>
								<td>G.728 (ITU-T)</td><td>LD-CELP</td><td>16</td><td>8</td><td>2.5</td><td>Very low delay</td>
							</tr>
							<tr>
								<td>G.729 (ITU-T)</td><td>CS-ACELP</td><td>8</td><td>8</td><td>10</td><td>Low delay (15 ms)</td>
							</tr>
							<tr>
								<td>G.729.1 (ITU-T)</td><td>CS-ACELP</td><td>8-32, step 2</td><td>8</td><td>10</td><td>WB</td>
							</tr>
							<tr>
								<td>GSM 06.10 (ETSI)</td><td>RPE-LTP</td><td>13</td><td>8</td><td>22.5</td><td>Mostly in GSM cellular; seldom in VoIP</td>
							</tr>
							<tr>
								<td>LPC10 (USA Gov)</td><td>LP</td><td>2.4</td><td>8</td><td>22.5</td><td>Very seldom used in VoIP</td>
							</tr>
							<tr>
								<td>Speex</td><td>CELP</td><td>8,16,32</td><td>NB &amp; WB</td><td>30 (NB), 34 (WB)</td><td>Also includes ECAN and NR features</td>
							</tr>
							<tr>
								<td>DoD CELP (DoD)</td><td>CELP</td><td>4.8</td><td></td><td>30</td><td></td>
							</tr>
							<tr>
								<td>EVRC (3GPP2)</td><td>RCELP</td><td>9.6/4.8/1.2</td><td>8</td><td>20</td><td>Enhanced Variable Rate CODEC; for CDMA</td>
							</tr>
							<tr>
								<td>DVI (IMA)</td><td>IMA</td><td>32</td><td>Variable</td><td>Sample-based</td><td></td>
							</tr>
							<tr>
								<td>SILK (Skype)</td><td>LPC</td><td>6-40</td><td>Variable</td><td>20</td><td>Adaptive bit-rate codec; low delay</td>
							</tr>
							<tr>
								<td>iLBC</td><td>AAC</td><td>8</td><td>13.3</td><td>30</td><td>NB (there is a 15,2 kbps version)</td>
							</tr>
						</table>
					</div>
					
					<ul style="margin-top: 70px;">
						<li><i class="ri-check-double-line"></i> Tables 1 and 2 include examples of codecs that are relatively frequently used in VoIP technology. The full list of waveform-codecs and model-based (for example, CELP) codecs is much longer. There are also many proprietary solutions for encoding and decoding speech signals following waveform coding as well as the model-based coding.</li>
					</ul>
				</div>
			</div>
			
			
			<a id="voipbusiness"></a>
			<div class="section-title" style="margin-top: 120px;">
			</div>
			
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-2 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/f9f8b11477b2dfd4ce2f248b089a8cd1.png" class="rounded  img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
					<h3>What Is VoIP Business?</h3>
					<p class="font-italic">
						VoIP is telephone service over the internet. VoIP has been around for a while now and is adopted worldwide by pretty much every organisation (startups, SMEs and even enterprises), and is the first choice for any organisation looking for a new phone system.
					</p>
					<a href="voip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
				</div>
			</div>
			
			<a id="connect"></a>
			<div class="section-title" style="margin-top: 120px;">
			</div>
			
			<div class="row" style="margin-bottom: 90px;">
				<div class="col-lg-6 order-1 order-lg-1 voip-img" data-aos="zoom-in" data-aos-delay="150">
					<img src="images/positive-young-businessman-headphones-eyeglasses-smiling-while-talking-business-partner-via-videoconferencing-phone.jpg" class="rounded  img-fluid animated" alt="">
				</div>
				<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
					<h3>How To Connect With VoIP To Network? ( Ways To Connect )</h3>
					<p class="font-italic">
						You have three ways to connect to our VoIP Business hosted / Cloud telephone system.
					</p>
					
					<div class="faq-list">
					<ul>
						<li data-aos="fade-up" data-aos-delay="100">
							<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>Web Phone</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
							<div id="faq-list-1" class="collapse" data-parent=".faq-list">
								<p>Use our web phone (works on all popular browsers).</p>
							</div>
						</li>
						<li data-aos="fade-up" data-aos-delay="200">
							<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>Soft Phone</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
							<div id="faq-list-2" class="collapse" data-parent=".faq-list">
								<p>Our soft phone is available on any device with any web browser.</p>
							</div>
						</li>
						<li data-aos="fade-up" data-aos-delay="300">
							<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>IP Phone</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
							<div id="faq-list-3" class="collapse" data-parent=".faq-list">
								<p>We have a good selection of business-grade desk and office phones.</p>
							</div>
						</li>
						<li data-aos="fade-up" data-aos-delay="400">
							<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>Mobile App</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
							<div id="faq-list-4" class="collapse" data-parent=".faq-list">
								<p>Our mobile app is in progress that would integrate also other CRMs.</p>
							</div>
						</li>
					</ul>
					</div>
				</div>
			</div>
			
			
			
			<?php include('public/ready_to_get_started.php');?> 
	
		</div>
	</section><!-- End Voip Section -->


</main><!-- End #main -->

<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>